base_dir = File.dirname(__FILE__)
ruby_groonga_base_dir = File.join(base_dir, "..", "..", "groonga")
ruby_groonga_base_dir = File.expand_path(ruby_groonga_base_dir)
$LOAD_PATH.unshift(File.join(ruby_groonga_base_dir, "ext"))
$LOAD_PATH.unshift(File.join(ruby_groonga_base_dir, "lib"))

require 'groonga'
require 'fileutils'

module Models
  class << self
    def db_path
      environment = ENV["RACK_ENV"] || "development"
      base_dir = File.dirname(__FILE__)
      db_dir ||= File.join(base_dir, "db", environment)
      FileUtils.mkdir_p(db_dir)
      db_path = File.join(db_dir, "db.groonga")
    end

    def setup(db_dir=nil)
      db_path = db_path()
      if File.exist?(db_path)
        Groonga::Database.open(db_path)
      else
        Groonga::Database.create(:path => db_path)
      end
      ensure_schema
    end

    def ensure_schema
      context = Groonga::Context.default
      Groonga::Schema.define do |schema|
        schema.create_table("sites", :type => :hash, :key_type => "ShortText", :force => true) do |table|
          table.short_text("url")
          table.short_text("summary")
        end
      end
    end
  end
end
