#!ruby
require 'rubygems'

require 'models'
Models.setup

require 'active_groonga'
ActiveGroonga::Base.database_path = Models.db_path

class Site < ActiveGroonga::Base
end

def find_or_create(key, url, summary)
  site = Site.find(key) || Site.new(:key => key)
  site.update_attributes(:url => url, :summary => summary)
end

find_or_create('groonga', "http://groonga.org/", "fulltext search engine")

GC.start

puts "select 1"
sites = Site.select { |rec| rec.key == 'groonga' }.paginate
GC.start

puts "select 2"
Site.select.sort
GC.start

puts "count"
puts sites.count
GC.start
